
<?php $__env->startSection('title', __('lang_v1.login')); ?>

<?php $__env->startSection('content'); ?>
    <div class="login-form col-md-12 col-xs-12 right-col-content">
        <p class="form-header text-white"><?php echo app('translator')->getFromJson('lang_v1.login'); ?></p>
        <form method="POST" action="<?php echo e(route('login'), false); ?>" id="login-form">
            <?php echo e(csrf_field(), false); ?>

            <div class="form-group has-feedback <?php echo e($errors->has('username') ? ' has-error' : '', false); ?>">
                <?php
                    $username = old('username');
                    $password = null;
                    if(config('app.env') == 'demo'){
                        $username = 'admin';
                        $password = '123456';
                    }
                ?>
                <input id="username" type="text" class="form-control" name="username" value="<?php echo e($username, false); ?>" required autofocus placeholder="<?php echo app('translator')->getFromJson('lang_v1.username'); ?>">
                <span class="fa fa-user form-control-feedback"></span>
                <?php if($errors->has('username')): ?>
                    <span class="help-block">
                        <strong><?php echo e($errors->first('username'), false); ?></strong>
                    </span>
                <?php endif; ?>
            </div>
            <div class="form-group has-feedback <?php echo e($errors->has('password') ? ' has-error' : '', false); ?>">
                <input id="password" type="password" class="form-control" name="password"
                value="<?php echo e($password, false); ?>" required placeholder="<?php echo app('translator')->getFromJson('lang_v1.password'); ?>">
                <span class="glyphicon glyphicon-lock form-control-feedback"></span>
                <?php if($errors->has('password')): ?>
                    <span class="help-block">
                        <strong><?php echo e($errors->first('password'), false); ?></strong>
                    </span>
                <?php endif; ?>
            </div>
            <div class="form-group">
                <div class="checkbox icheck">
                    <label>
                        <input type="checkbox" name="remember" <?php echo e(old('remember') ? 'checked' : '', false); ?>> <?php echo app('translator')->getFromJson('lang_v1.remember_me'); ?>
                    </label>
                </div>
            </div>
            <br>
            <div class="form-group">
                <button type="submit" class="btn btn-primary btn-flat btn-login"><?php echo app('translator')->getFromJson('lang_v1.login'); ?></button>
                <?php if(config('app.env') != 'demo'): ?>
                <a href="<?php echo e(route('password.request'), false); ?>" class="pull-right">
                    <?php echo app('translator')->getFromJson('lang_v1.forgot_your_password'); ?>
                </a>
            <?php endif; ?>
            </div>
        </form>
    </div>
    <?php if(config('app.env') == 'demo'): ?>
    <div class="col-md-12 col-xs-12" style="padding-bottom: 30px;">
          
    </div>
    <?php endif; ?> 
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
    $(document).ready(function(){
        $('#change_lang').change( function(){
            window.location = "<?php echo e(route('login'), false); ?>?lang=" + $(this).val();
        });

        $('a.demo-login').click( function (e) {
           e.preventDefault();
           $('#username').val($(this).data('admin'));
           $('#password').val("<?php echo e($password, false); ?>");
           $('form#login-form').submit();
        });
    })
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/wlsystem/nex.wlsystems.com.br/resources/views/auth/login.blade.php ENDPATH**/ ?>