<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class CreateDefaultDataForCms extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::beginTransaction();

        $cms_site_details = array(
            array('id' => '1','site_key' => 'faqs','site_value' => '[{"question":"Por que devo mudar para um software de gerenciamento de negócios baseado em nuvem em comparação com o software de desktop tradicional?","answer":"O software baseado em nuvem fornece soluções de software móveis, seguras e de baixo custo. Em comparação com o software tradicional que requer a instalação em um computador - baseado em nuvem pode ser acessado de qualquer lugar sem nenhuma dependência de hardware."},{"question":"Quão seguros estão os dados da minha empresa?","answer":"Todos os dados são armazenados em nosso banco de dados centralizado, altamente protegido com várias camadas de privilégios. Tomamos backup automatizado de intervalo de frequência regular para proteger de quaisquer consequências indesejadas."},{"question":"A quem devo recorrer em caso de problemas?","answer":"Entre em contato com nosso suporte, escreva-nos na seção de contato ou ligue para o número mencionado. Você tem a certeza de receber uma resposta em no máximo 24 horas."},{"question":"Este aplicativo de PDV é gratuito?","answer":"Nós fornecemos um nível gratuito para empresas muito pequenas ou empresas que estão prestes a começar. Para aproveitar mais este software POS, recomendamos que você atualize para um plano melhor que desbloqueie mais recursos."},{"question":"Você fornece soluções de consultoria ou implementação para usar este software PDV?","answer":"Sim, com um plano profissional você pode se conectar com um de nossos especialistas que o ajudará a implementar a solução para o seu negócio."},{"question":"É necessário algum hardware adicional ou taxas de assinatura?","answer":"Este é um software baseado em nuvem. Você só precisará de um dispositivo com conexão à Internet e navegador Chrome. Ele é executado dentro do navegador. Nenhum hardware adicional é necessário. Mas você pode usar algum hardware como leitores de código de barras e impressoras para sua conveniência para acelerar o trabalho."}]','created_at' => '2022-09-13 18:44:10','updated_at' => '2022-10-20 17:16:28'),
            array('id' => '2','site_key' => 'statistics','site_value' => '{"tagline":"Estatísticas e números do PDV","description":"Mais e mais empresas estão adotando nossa solução de gerenciamento de negócios baseada em nuvem","content":[{"stats":"75","title":"NEGÓCIOS REGISTRADOS"},{"stats":"400+","title":"USUÁRIOS DIÁRIOS"},{"stats":"50M","title":"FATURAS CRIADAS"},{"stats":"126+","title":"RECURSOS ONLINE"}]}','created_at' => '2022-09-13 18:44:10','updated_at' => '2022-10-20 17:08:07'),
            array('id' => '3','site_key' => 'google_analytics','site_value' => 'null','created_at' => '2022-09-14 11:14:40','updated_at' => '2022-09-16 11:49:09'),
            array('id' => '4','site_key' => 'fb_pixel','site_value' => 'null','created_at' => '2022-09-14 11:14:40','updated_at' => '2022-09-16 11:49:09'),
            array('id' => '5','site_key' => 'custom_js','site_value' => 'null','created_at' => '2022-09-14 11:14:40','updated_at' => '2022-09-16 11:49:09'),
            array('id' => '6','site_key' => 'custom_css','site_value' => 'null','created_at' => '2022-09-14 11:14:40','updated_at' => '2022-09-16 11:49:09'),
            array('id' => '7','site_key' => 'meta_tags','site_value' => 'null','created_at' => '2022-09-14 11:14:40','updated_at' => '2022-09-16 11:49:09'),
            array('id' => '8','site_key' => 'chat_widget','site_value' => 'null','created_at' => '2022-09-14 11:27:14','updated_at' => '2022-09-16 11:49:09'),
            array('id' => '9','site_key' => 'contact_us','site_value' => '[{"label":"Fone","num":"48998463846"},{"label":"Suporte","num":"48998463846"},{"label":"Vendas","num":"48998463846"}]','created_at' => '2022-09-14 12:24:38','updated_at' => '2022-09-16 11:49:09'),
            array('id' => '10','site_key' => 'mail_us','site_value' => '[{"label":"Contato","email":"contato@exemplo.com"},{"label":"Suporte","email":"suporte@exemplo.com"}]','created_at' => '2022-09-14 12:24:38','updated_at' => '2022-09-16 11:49:09'),
            array('id' => '11','site_key' => 'follow_us','site_value' => '{"facebook":"https:\\/\\/www.facebook.com\\/test","instagram":"https:\\/\\/www.instagram.com\\/test","twitter":"https:\\/\\/twitter.com\\/test","linkedin":"https:\\/\\/in.linkedin.com\\/company\\/test","youtube":"https:\\/\\/www.youtube.com\\/c\\/test"}','created_at' => '2022-09-14 12:35:39','updated_at' => '2022-10-20 17:08:07'),
            array('id' => '12','site_key' => 'logo','site_value' => 'null','created_at' => '2022-09-14 13:38:53','updated_at' => '2022-09-16 11:49:09'),
            array('id' => '13','site_key' => 'notifiable_email','site_value' => '"notifiqueme@exemplo.com"','created_at' => '2022-09-14 13:38:53','updated_at' => '2022-09-16 11:49:09')
          );
          
        DB::table('cms_site_details')->insert($cms_site_details);


        $cms_pages = array(
            array('id' => '1','type' => 'testimonial','layout' => NULL,'title' => 'David Silva','content' => '<p class="testimonial-card-1__paragraph mb-3">Este software tornou-se um dos pilares do nosso negócio. Isso nos ajudou a simplificar os dados de todos os nossos armazéns e depósitos. lojas em uma plataforma. Não sou um cara muito técnico, mas o painel de administração também permite que você personalize todos os aspectos do aplicativo.</p>
          <p class="testimonial-card-1__paragraph mb-3">Todos os relatórios me ajudam a dar uma visão geral dos diferentes aspectos do nosso negócio.</p>
          <p class="testimonial-card-1__paragraph mb-3">É muito poderoso!</p>','meta_description' => NULL,'tags' => NULL,'feature_image' => NULL,'priority' => '3','created_by' => '9','is_enabled' => '1','created_at' => '2022-08-19 11:25:05','updated_at' => '2022-10-20 17:48:29'),
            array('id' => '2','type' => 'testimonial','layout' => NULL,'title' => 'Tony Andrade','content' => '<p>Ele foi realmente projetado para ajudar meu negócio a funcionar de maneira mais suave e eficiente. Agora posso rastrear e gerenciar inventário, informações de clientes e vendas com facilidade. A instalação foi rápida e fácil, e a interface é muito amigável. Agora posso gerenciar quase todas as operações comerciais com um único software!</p>','meta_description' => NULL,'tags' => NULL,'feature_image' => NULL,'priority' => NULL,'created_by' => '1','is_enabled' => '1','created_at' => '2022-09-10 16:07:17','updated_at' => '2022-10-20 17:23:39'),
            array('id' => '3','type' => 'page','layout' => 'home','title' => 'Automatize a gestão do seu negócio a um custo muito baixo','content' => '<p>Melhor PDV, Faturamento, Estoque &amp; Aplicativo de gerenciamento de serviços para o seu negócio em crescimento!</p>','meta_description' => NULL,'tags' => NULL,'feature_image' => NULL,'priority' => '1','created_by' => '0','is_enabled' => '1','created_at' => '2022-09-10 16:26:24','updated_at' => '2022-10-20 16:30:15'),
            array('id' => '4','type' => 'page','layout' => 'contact','title' => 'Contate-nos','content' => '<p>Ficamos felizes em receber sua mensagem. Pergunte-nos qualquer coisa, responderemos o mais breve possível.</p>','meta_description' => NULL,'tags' => NULL,'feature_image' => NULL,'priority' => NULL,'created_by' => '0','is_enabled' => '1','created_at' => '2022-09-10 16:26:24','updated_at' => '2022-09-16 12:04:20'),
            array('id' => '5','type' => 'testimonial','layout' => NULL,'title' => 'Cristina Pereira','content' => '<p>Nós usamos isso por 9 meses agora. Isso ajudou nosso negócio a crescer aos trancos e barrancos. A interface e sua simplicidade facilitaram nosso aprendizado e familiarização. A melhor coisa sobre este software é que ele é baseado em nuvem e podemos usá-lo em nossa loja, depósito ou celular enquanto viajamos. Também posso ver seu potencial à medida que continuamos a crescer. Altamente Satisfeita!</p>','meta_description' => NULL,'tags' => NULL,'feature_image' => NULL,'priority' => NULL,'created_by' => '1','is_enabled' => '1','created_at' => '2022-09-16 12:07:25','updated_at' => '2022-10-20 17:27:31')
          );
        DB::table('cms_pages')->insert($cms_pages);

        $cms_page_metas = array(
            array('id' => '1','cms_page_id' => '3','meta_key' => 'industry','meta_value' => '{"id":"1","title":"Estamos prontos para o seu negócio!","description":"<p>Se você precisa de um software de gestão empresarial, veio ao lugar certo.&nbsp;<\\/p>\\r\\n<p>Temos um design modular limpo e moderno que certamente se adequará ao seu negócio!<\\/p>","content":[{"icon":"fas fa-store-alt","title":"Loja de departamentos","description":"Procurando uma solução de software que possa ajudá-lo a gerenciar e vender todos os seus itens essenciais em um só lugar? Não procure mais do que nosso software de loja de departamentos completo. Se você precisa vender roupas, sapatos, bolsas ou qualquer outro tipo de item, nosso software o cobre. Além disso, nossa interface fácil de usar torna simples começar a vender imediatamente. Então, por que esperar? Comece hoje!"},{"icon":"fas fa-store","title":"Varejo e atacado","description":"Um conjunto completo de recursos para gerenciar lojas de varejo e atacado. Defina vários preços para diferentes segmentos de clientes ou diferentes locais de negócios."},{"icon":"fas fa-notes-medical","title":"Farmacia","description":"Nosso software é perfeito para qualquer empresa farmacêutica. Você pode definir datas de validade e números de lote do produto e vender em diferentes unidades de medida. Pare de vender itens vencidos e a expirar aos clientes. Verifique os relatórios de detalhes sobre o vencimento do estoque por números de lote"},{"icon":"fas fa-prescription-bottle","title":"Bebidas","description":"Fácil de usar para cada loja de bebidas. Vender em ml e vender a garrafa, você pode gerenciá-los facilmente."},{"icon":"fas fa-mobile-alt","title":"Celulares e eletrônicos","description":"Registre o número de série do estoque, venda itens com número de série específico."},{"icon":"fas fa-wrench","title":"Oficina","description":"Um conjunto completo de recursos para gerenciar negócios de reparo, criar planilha de trabalho, atribuir planilha de trabalho a técnico, status de reparo, converter planilha de trabalho em faturas. Link automático para os clientes verificarem o andamento do reparo"},{"icon":"fas fa-home","title":null,"description":null},{"icon":"fas fa-home","title":null,"description":null}]}','created_at' => NULL,'updated_at' => '2022-10-20 16:30:15'),
            array('id' => '2','cms_page_id' => '3','meta_key' => 'feature','meta_value' => '{"id":"2","title":"Recursos para disparar \\ud83d\\ude80 o crescimento do seu negócio","description":"<p>O ritmo de crescimento dos negócios nunca foi tão rápido.<\\/p>\\r\\n<p>É por isso que desenvolvemos nosso software de PDV baseado em nuvem para ajudá-lo a progredir.<\\/p>\\r\\n<p>A maneira mais fácil e confiável de expandir e gerenciar seus negócios está ao seu alcance com nosso sistema de PDV e gerenciamento de inventário baseado em nuvem.<\\/p>\\r\\n<p>O software certo pode salvar a vida do seu negócio e, com ele, você pode revolucionar o crescimento do seu negócio<\\/p>","content":[{"icon":"fas fa-cloud","title":"Acesse em qualquer lugar!","description":"Verifique os dados da sua empresa de qualquer lugar, a qualquer hora. \\r\\nVeja atualizações ao vivo em tempo real"},{"icon":"fas fa-check-double","title":"Sem instalação","description":"Nenhum software para instalar, nenhuma dependência de hardware. Basta abrir o navegador e começar a usar."},{"icon":"fas fa-sitemap","title":"Multifiliais e Armazém","description":"Gerencie o estoque de várias filiais em um só lugar sem esforço e em tempo real."},{"icon":"fas fa-user-lock","title":"Limite de acesso do usuário","description":"Poderoso gerenciamento de função e permissão do usuário para limitar o acesso dos funcionários aos dados corporativos"},{"icon":"fas fa-cubes","title":"Gestão de Estoque","description":"Gerencie estoques de vários locais, vencimento de estoque, número de lote, histórico de estoque e muito mais."},{"icon":"fas fa-wrench","title":"Gerenciamento de serviços","description":"Gerencie e fature facilmente os serviços. Também recursos de gerenciamento de serviços de reparo dedicados para agendar e entregar serviços no prazo"},{"icon":"fas fa-users","title":"Gestão de RH","description":"Com o gerenciamento de RH, rastreie facilmente a frequência diária, gerenciamento de turnos, licenças, folha de pagamento, feriados, departamentos e designações"},{"icon":"fas fa-handshake","title":"Gestão de Clientes","description":"O módulo de CRM ajuda você a rastrear o ciclo de vida dos leads, acompanhar os leads, fontes, acompanhamento, lançar campanhas, propostas e muito mais"},{"icon":"fas fa-hand-peace","title":"Interface simplificada","description":"Interface simples de usar para realizar o trabalho com poucos cliques. Economize seu tempo e facilite o uso para os funcionários."},{"icon":"fas fa-chart-line","title":"Relatórios","description":"Vem embutido com muitos relatórios para ajudar os proprietários de empresas a analisar todas as receitas, estoque, pagamentos e recursos humanos."}]}','created_at' => '2022-09-15 15:34:41','updated_at' => '2022-10-20 15:39:11')
          );
        DB::table('cms_page_metas')->insert($cms_page_metas);
        
        DB::commit();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
